<?php

namespace Mtc\ShippingManager\Console\Commands;

use Illuminate\Console\Command;
use Mtc\ShippingManager\Providers\ShippingServiceProvider;
use Mtc\ShippingManager\Seeds\ShippingManagerSeeder;

/**
 * Class InstallShippingManager
 *
 * @package Mtc\ShippingManager
 */
class InstallShippingManager extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'shipping:install';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Shipping Manager default assets/data';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $this->info('Installing Shipping Manager');
        $this->callSilent('migrate');

        $this->callSilent('vendor:publish', [
            '--provider' => ShippingServiceProvider::class,
            '--tag' => 'assets',
        ]);

        $this->comment('Setting up database');
        $this->call('db:seed', [
            '--class' => ShippingManagerSeeder::class
        ]);

        $this->info('Shipping Manager installed successfully.');
    }
}
