<?php

namespace Mtc\Sagepay\Providers;

use Illuminate\Support\ServiceProvider;
use Mtc\Sagepay\Sagepay;

/**
 * Class SagepayServiceProvider
 *
 * @package Mtc\Sagepay
 */
class SagepayServiceProvider extends ServiceProvider
{
    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/sagepay.php', 'sagepay');
    }

    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'sagepay');
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');

        $this->app['payment']->extend('sagepay', function ($app) {
            return new Sagepay();
        });

        if ($this->app->runningInConsole()) {
            $this->publishes([
                dirname(__DIR__, 2) . '/config/sagepay.php' => config_path('sagepay.php'),
            ], 'config');

            // Publishing the translation files.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/lang' => resource_path('lang/vendor/sagepay'),
            ], 'lang');

        }
    }

}
