document.addEventListener('DOMContentLoaded', async () => {
    const container = document.getElementById('revolut-pay-container');
    const loader = document.getElementById('revolut-pay-loading');
    const errorBox = document.getElementById('revolut-error-message');
    const errorText = errorBox?.querySelector('.error-message');

    if (!container) {
        console.warn('Revolut container not found.');
        return;
    }

    // Show loader
    if (loader) loader.style.display = 'block';

    try {
        const basketJson = container.dataset.basket;

        const response = await fetch('/revolut/order', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: basketJson
        });

        const result = await response.json();

        if (result.checkout_url) {
            const buttonContainer = document.getElementById('revolut-pay-button');
            if (!buttonContainer) {
                console.error('Button container not found');
                return;
            }

            const button = document.createElement('button');
            button.id = 'revolut-pay-button-element';
            button.className = 'revolut-pay-button';
            button.textContent = 'Pay with Revolut';
            button.style.cssText = 'width: 100%; padding: 10px; background-color: #000; color: #fff; border: none; border-radius: 4px; cursor: pointer;';

            buttonContainer.appendChild(button);

            button.addEventListener('click', async (e) => {
                e.preventDefault();
                try {
                    const responsePayment = await fetch('/revolut/order/new', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(result)
                    });

                    if (responsePayment.ok) {
                        window.location.href = result.checkout_url;
                    } else {
                        console.error('Failed to save payment response');
                    }
                } catch (error) {
                    console.error('Network error:', error);
                }
            });
        }

        //console.log('Response from /revolut/order:', result);
    } catch (e) {
        console.error('Error:', e);
        if (errorBox && errorText) {
            errorText.textContent = 'Failed to load Revolut payment data. Please try again.';
            errorBox.style.display = 'block';
        }
    } finally {
        // Hide loader whether success or failure
        if (loader) loader.style.display = 'none';
    }
});
