<?php

    namespace Mtc\RevolutPaymentProvider\Classes\Operations;

    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Http;
    use Mtc\RevolutPaymentProvider\Services\RevolutOrderService;
    use Mtc\RevolutPaymentProvider\Classes\RevolutPayment;
    use Mtc\Modules\Members\Classes\Auth;
    use Illuminate\Support\Facades\Log;
    use Mtc\Shop\Order\Note;



    class Refund
    {



        public static function handleRefund($orderId, $amount): void
        {
            Log::debug("Revolut handleRefund {$orderId}, {$amount}\n");
            /** @var RevolutPayment $payment */
            $payment = RevolutPayment::where('order_id', $orderId)
                ->whereIn('status', [
                    RevolutPayment::STATUS_AUTHORIZED,
                    RevolutPayment::STATUS_COMPLETED,
                ])->first();;
            Log::debug("!!!Query showing".json_encode($payment)."\n");
            Log::debug("====================="."\n");
            Log::debug("DB Payment Status".$payment->status."\n");
            Log::debug("====================="."\n");
            Log::debug($payment["status"]);

            $amount = $amount * 100;
            $fullRefund = $payment->amount * 100;

    //        $refundAmount = $fullRefund;

            Log::debug("TEST MODE: ". config("revolut.test_mode")."\n");

            $endpoint = config("revolut.api_url")."/api/1.0/orders/{$payment->transaction_id}/refund";
            Log::debug("Refund API endpoint {$endpoint}\n");

            $headers = [
                'Authorization'  => "Bearer ".config('revolut.api_key'),
                'Content-Type'  => 'application/json',
                'Revolut-Api-Version' => "2024-09-01",
                'Idempotency-Key' => $payment->transaction_id
            ];

            $httpRequest = Http::withHeaders($headers);


            if ($payment->status === RevolutPayment::STATUS_COMPLETED) {
                $refundAmount = $amount ? $amount : $fullRefund;
                $payload= [
                    "amount" => $refundAmount,
                    "description" => "Refunding {$refundAmount} for order {$orderId}",
                    "merchant_order_ext_ref"=>$orderId,
                ];
                Log::debug("Payoload Refund Data : ".json_encode($payload));


                try{
                    try {
                        $result = $httpRequest
                            ->withOptions([
                                'verify' => false,
                            ])
                            ->post($endpoint, $payload)->collect();

                        Log::debug(json_encode($result)."\n");

                    }catch (\Exception $exceptionSend){
                        Log::error($exceptionSend->getMessage()."\n");
                    }


                    RevolutPayment::query()->create(
                        [
                            'order_id' => $orderId,
                            "user_id"   =>$payment->user_id,
                            "type"=> strtolower($result["type"]),
                            "member_id" => $payment->member_id,
                            'member_email' => $payment->member_email,
                            'transaction_id' => $result["id"] ,
                            'status' => strtolower($result["state"]),
                            'amount' => ($result["order_amount"]["value"] ?? 0) / 100,
                            'currency' => $result["order_amount"]['currency'] ?? 'GBP',
                            'token' => null,
                            'checkout_url' => null,

                            "raw_response"=>$result->toJson(),
                        ],
                    );

                }catch (\Exception $exception){
                    Log::error($exception->getMessage());
                }
            } else {
                if ($fullRefund) {
                    $refundAmount = $fullRefund ?? $amount;
                    $payload= [
                        "amount" => $refundAmount ,
                        "description" => "Refunding {$refundAmount} for order {$orderId}",
                        "merchant_order_ext_ref"=>$orderId,
                    ];


                    $result = Http::withHeaders($headers)
                        ->post($endpoint, $payload)->collect();
                    Log::info(json_encode($result));
                    RevolutPayment::query()->create(
                        [
                            'order_id' => $orderId,
                            "user_id"   =>$payment->user_id,
                            "type"=> strtolower($result["type"]),
                            "member_id" => $payment->member_id,
                            'member_email' => $payment->member_email,
                            'transaction_id' => $result["id"] ,
                            'status' => strtolower($result["state"]),
                            'amount' => ($result["order_amount"]["value"] ?? 0) / 100,
                            'currency' => $result["order_amount"]['currency'] ?? 'GBP',
                            'token' => null,
                            'checkout_url' => null,

                            "raw_response"=>$result->toJson(),
                        ],
                    );


                    Log::debug(print_r($result, true));
                } else {
                    $chargeAmount = $payment->amount - $amount;

                    $refundAmount = $chargeAmount;
                    $payload= [
                        "amount" => $refundAmount ,
                        "description" => "Refunding {$refundAmount} for order {$orderId}",
                        "merchant_order_ext_ref"=>$orderId,
                    ];

                    $result = Http::withHeaders($headers)
                        ->post($endpoint, $payload)->collect();
                    Log::debug($result);

                    RevolutPayment::query()->create(
                        [
                            'order_id' => $orderId,
                            "type"=> strtolower($result["type"]),
                            "member_id" => $payment->member_id,
                            "user_id"   =>$payment->user_id,
                            'member_email' => $payment->member_email,
                            'transaction_id' => $result["id"] ,
                            'status' => strtolower($result["state"]),
                            'amount' => ($result["order_amount"]["value"] ?? 0) / 100,
                            'currency' => $result["order_amount"]['currency'] ?? 'GBP',
                            'token' => null,
                            'checkout_url' => null,

                            "raw_response"=>$result->toJson(),
                        ],
                    );
                }
            }

            if (!$result) {
                throw new \Exception('Failed to create a refund!');
            }

            Note::query()
                ->create([
                    'order_id' => $orderId,
                    'note' => 'A Revolut refund request for £' . $amount/100 . ' has been sent',
                ]);
        }

    }
