<?php

    namespace Database\Seeders;


    use Illuminate\Database\Seeder;
    use Illuminate\Support\Facades\DB;


    class RevolutSettingsSeeder extends Seeder
    {
        public function run()
        {
            echo 'Seeding REVOLUT Settings...' . PHP_EOL;
            $data = [
                [
                    "key" => "REVOLUT_ENABLED",
                    "environment" => "",
                    "type" => "bool",
                    "value" => false,
                    "module" => "REVOLUT",
                    "description" => "Enable / Disable module",
                    'updated_at'=>new \DateTime(),
                    'created_at' => new \DateTime(),
                ],
                [
                    "key" => "REVOLUT_TEST_MODE",
                    "environment" => "",
                    "type" => "bool",
                    "value" => true,
                    "module" => "REVOLUT",
                    "description" => "Enable / Disable test mode",
                    'updated_at'=>new \DateTime(),
                    'created_at' => new \DateTime(),
                ],
                [
                    "key" => "REVOLUT_SANDBOX_API_KEY",
                    "environment" => "",
                    "type" => "string",
                    "value" => "sk_......",
                    "module" => "REVOLUT",
                    "description" => "Sandbox API SECRET Key",
                    'updated_at'=>new \DateTime(),
                    'created_at' => new \DateTime(),
                ],
                [
                    "key" => "REVOLUT_SANDBOX_PUBLIC_KEY",
                    "environment" => "",
                    "type" => "string",
                    "value" => "pk_.....",
                    "module" => "REVOLUT",
                    "description" => "Sandbox API PUBLIC Key",
                    'updated_at'=>new \DateTime(),
                    'created_at' => new \DateTime(),
                ],
                [
                    "key" => "REVOLUT_SANDBOX_API_URL",
                    "environment" => "",
                    "type" => "string",
                    "value" => "https://sandbox-merchant.revolut.com",
                    "module" => "REVOLUT",
                    "description" => "Sandbox API URL",
                    'updated_at'=>new \DateTime(),
                    'created_at' => new \DateTime(),
                ],
                [
                    "key" => "REVOLUT_SANDBOX_WEBHOOK_SECRET",
                    "environment" => "",
                    "type" => "string",
                    "value" => "wsk_......",
                    "module" => "REVOLUT",
                    "description" => "Sandbox API WEBHOOK SECRET",
                    'updated_at'=>new \DateTime(),
                    'created_at' => new \DateTime(),
                ],
                [
                    "key" => "REVOLUT_SANDBOX_WEBHOOK_ID",
                    "environment" => "",
                    "type" => "string",
                    "value" => "[string-id-returned from post]",
                    "module" => "REVOLUT",
                    "description" => "Sandbox API WEBHOOK ID",
                    'updated_at'=>new \DateTime(),
                    'created_at' => new \DateTime(),
                ],
                [
                    "key" => "REVOLUT_LIVE_API_KEY",
                    "environment" => "",
                    "type" => "string",
                    "value" => "sk_......",
                    "module" => "REVOLUT",
                    "description" => "LIVE API SECRET Key",
                    'updated_at'=>new \DateTime(),
                    'created_at' => new \DateTime(),
                ],
                [
                    "key" => "REVOLUT_LIVE_PUBLIC_KEY",
                    "environment" => "",
                    "type" => "string",
                    "value" => "pk_......",
                    "module" => "REVOLUT",
                    "description" => "LIVE API PUBLIC Key",
                    'updated_at'=>new \DateTime(),
                    'created_at' => new \DateTime(),
                ],
                [
                    "key" => "REVOLUT_LIVE_API_URL",
                    "environment" => "",
                    "type" => "string",
                    "value" => "https://merchant.revolut.com",
                    "module" => "REVOLUT",
                    "description" => "LIVE API URL",
                    'updated_at'=>new \DateTime(),
                    'created_at' => new \DateTime(),
                ],
                [
                    "key" => "REVOLUT_LIVE_WEBHOOK_SECRET",
                    "environment" => "",
                    "type" => "string",
                    "value" => "wsk_......",
                    "module" => "REVOLUT",
                    "description" => "LIVE API WEBHOOK SECRET",
                    'updated_at'=>new \DateTime(),
                    'created_at' => new \DateTime(),
                ],
                [
                    "key" => "REVOLUT_LIVE_WEBHOOK_ID",
                    "environment" => "",
                    "type" => "string",
                    "value" => "[string-id-returned from post]",
                    "module" => "REVOLUT",
                    "description" => "LIVE API WEBHOOK ID",
                    'updated_at'=>new \DateTime(),
                    'created_at' => new \DateTime(),
                ]
            ];
            DB::table('settings')->insert($data);
        }

    }
