<?php
    namespace Mtc\RevolutPaymentProvider\Support;

    use GuzzleHttp\Client;
    use GuzzleHttp\Exception\GuzzleException;
    use Illuminate\Support\Facades\Log;
    use Illuminate\Support\Facades\Http;
    use Illuminate\Http\Request;
    use Illuminate\Routing\Controller as BaseController;

    class Proxy extends BaseController
    {

        private $baseUrl;
        public $headers;

        public function __construct(
            public Request $request
        )
        {

            $this->headers = [
                'Authorization'  => "Bearer ".config('revolut.api_key'),
                'Content-Type'  => 'application/json',
                'Revolut-Api-Version' => "2024-09-01"
            ];
            $this->baseUrl = config("revolut.api_url");

        }

        public function makeRevolutApiRequest($endpoint)
        {
            $queryString = $this->request->getQueryString();

            if ($queryString) {
                $endpoint .= '?' . $queryString;
            }

            // Strip '/revolut-api' prefix if present
            $endpoint = preg_replace('#^/?revolut-api#', '', $endpoint);

            $url = rtrim($this->baseUrl, '/') . '/' . ltrim($endpoint, '/');
            $httpRequest = Http::withHeaders($this->headers);
            // Add body for certain HTTP methods
            if (in_array($this->request->method(), ['POST', 'PUT', 'PATCH', 'DELETE'])) {
                $httpRequest = $httpRequest->withBody($this->request->getContent(), 'application/json');
            }

            try{
                $response = $httpRequest->withOptions([
                    'verify' => false,
                ])
                    ->send($this->request->method(), $url)
                    ->throw()
                ;
                return $response->collect();

            }catch (\Exception $e){
                Log::error('Revolut API request failed', [
                    'message' => $e->getMessage(),
                    'trace' => $e->getTraceAsString(),
                ]);
                abort(500, "Revolut API request failed: " . $e->getMessage());
            }
        }

        public function proxyRevolutApiRequest($endpoint)
        {


            $resonse = $this->makeRevolutApiRequest($endpoint);

            return response($resonse->toJson(),200)
                ->header('Content-Type', 'application/json');
        }

    }
