<?php
    namespace Mtc\RevolutPaymentProvider\Services;

    use Illuminate\Support\Facades\Cache;
    use Illuminate\Support\Facades\Log;
    use Illuminate\Support\Facades\Http;

    class RevolutOrderService
    {
        protected $client;
        const ENDPOINT= "/revolut-api/api/orders";



        public function createOrder($basket){

            $url =env('APP_URL').self::ENDPOINT;

            $body = [
                'amount' => intval($basket['cost_total'] * 100),
                'currency' => $basket['currency'] ?? 'GBP',
                'capture_mode'=> 'automatic',
                'customer' => [
                    'email' => $basket['info'] ?? '',
                    // 'date_of_birth' => '1990-01-01' // if you have this info
                ],
                'description' => 'Order #' . ($basket['orderId'] ?? ''),
                'shipping' => [
                    'address' => [
                        'street_line_1' => $basket['address']['address1'] ?? '',
                        'street_line_2' => $basket['address']['address2'] ?? '',
                        'city' => $basket['address']['city'] ?? '',
                        'country_code' => $basket['address']['country'] ?? '',
                        'postcode' => $basket['address']['postcode'] ?? '',
                    ],
                    'contact' => [
                        'email' => $basket['info'] ?? '',
                        'name'=> $basket['address']['firstname'].' '.$basket['address']['lastname'] ?? '',
                        'phone' => $basket['phone']??''
                    ]
                ],
                'enforce_challenge' => 'forced',
                'statement_descriptor_suffix' => (string) ($basket['orderId'] ?? ''),
                'redirect_url' => env('APP_URL') . '/revolut/success',
            ];

            foreach ($basket["items"] as $item) {
                $body["items"][] = [
                    "name" => $item["item_name"],
                    "unit_price_amount" => $item["item_price"],
                    'total_amount' => $item["item_price"] * $item["quantity"],
                    "quantity" => $item["quantity"],
                    "external_id" => $item["item_id"]
                ];
            }

            return Http::post($url, $body)->throw()->collect();

        }

    }
