<?php

    namespace Mtc\RevolutPaymentProvider\Controllers\Webhook\Order;

    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Log;
    use Mtc\RevolutPaymentProvider\Classes\RevolutPayment;

    use Mtc\Shop\Order\Note;


    class RevolutWebhookOrderController
    {

        public function __construct(
            public Request $request
        )
        {
        }

        public function manage(Request $request)
        {
            Log::info('RevolutWebhookOrderController::manage');
            Log::info($this->request->all());

            $data = $request->all();

            if (!isset($data['event']) || !isset($data['order_id'])) {
                Log::warning('Webhook missing event_type or order_id.');
                return response()->json(['error' => 'Invalid payload'], 400);
            }

            $eventType = $data['event'];
            $orderId = $data['order_id'];

            $revoultTransaction = RevolutPayment::where('transaction_id', $orderId)->first();


            $updated = match ($eventType) {
                'ORDER_AUTHORISED'=> tap (true, function() use ($orderId,$revoultTransaction,$eventType) {
                    $status = RevolutPayment::STATUS_AUTHORIZED;
                    $revoultTransaction->update(['status' => $status]);
                    $note = "Webhook: Revolut order {$orderId} to {$status}";
                    Log::info($note);
                    $this->setNote($eventType, $revoultTransaction->order_id, $note );
                    return true;
                }),

                'ORDER_COMPLETED'=> tap( true, function() use ($orderId,$revoultTransaction,$eventType) {
                    $status = RevolutPayment::STATUS_COMPLETED;
                    $revoultTransaction->update(['status' => $status]);
                    $note = "Webhook: Revolut order {$orderId} to {$status}";
                    Log::info($note);
                    $this->setNote($eventType, $revoultTransaction->order_id, $note );
                    return true;
                }),
                default=> false

            };

            return response()->json(['success' => true]);
        }
        public function setNote($eventType, $orderId, $note)
        {
            Note::query()
                ->create([
                    'order_id' => $orderId,
                    'note' => $note,
                ]);
        }
    }
