<?php

namespace Mtc\RevolutPaymentProvider\Controllers;

use Illuminate\Http\Request;
use Mtc\RevolutPaymentProvider\Services\RevolutOrderService;
use Mtc\RevolutPaymentProvider\Classes\RevolutPayment;
use Mtc\Modules\Members\Classes\Auth;


class RevolutOrderController
{


    public function __construct(
        protected RevolutOrderService $revolutService
    )
    {}

    public function createOrder(Request $request)
    {
        $data = $request->all();
        $dataResponse = $this->revolutService->createOrder($data);

        RevolutPayment::updateOrCreate(
            ['order_id' => $dataResponse['statement_descriptor_suffix'] ?? null],
            [
                'user_id' => Auth::getLoggedInMember()->id,
                'member_id' => $dataResponse['customer']['id'] ?? null,
                'member_email' => $dataResponse['customer']['email'] ?? null,
                'transaction_id' => $dataResponse['id'] ?? null,
                'status' => $dataResponse['state'] ?? 'pending',
                'amount' => ($dataResponse['amount'] ?? 0) / 100,
                'currency' => $dataResponse['currency'] ?? 'GBP',
                'token' => $dataResponse['token'] ?? null,
                'checkout_url' => $dataResponse['checkout_url'] ?? null,
                'raw_response' => $dataResponse,
            ]
        );

        $_SESSION['revolut_order_id'] = $dataResponse['statement_descriptor_suffix'];

        return response()->json($dataResponse);
    }







}
