<?php

    namespace Mtc\RevolutPaymentProvider\Classes\Operations;


    use Illuminate\Http\Request;
    use Mtc\RevolutPaymentProvider\Services\RevolutOrderService;
    use Mtc\RevolutPaymentProvider\Classes\RevolutPayment;
    use Mtc\Modules\Members\Classes\Auth;



    class Refund
    {


        public function __construct(
            protected RevolutOrderService $revolutService,
            protected Request $request,
        )
        {}



    public static function handleRefund($orderId, $amount): void
    {
        Log::debug('Revolut handleRefund');
        /** @var RevolutPayment $payment */
        $payment = RevolutPayment::query()
            ->where('order_id', $orderId)
            ->whereIn('status', [
                RevolutPayment::STATUS_RESERVED,
                RevolutPayment::STATUS_COMPLETED,
            ])
            ->firstOrFail();

        Log::debug(print_r($payment, true));
        if (!empty($amount)) {
            $amount = number_format($amount, 2);
            $fullRefund = $amount == $payment->amount;
        } else {
            $amount = $payment->amount;
            $fullRefund = true;
        }

        if ($payment->status === RevolutPayment::STATUS_COMPLETED) {
            $result = (new self())->refundPayment($payment, $fullRefund ? null : $amount);


        } else {
            if ($fullRefund) {
                $result = (new self())->cancelPayment($payment);
            } else {
                $chargeAmount = $payment->amount - $amount;
                $result = (new self())->capturePayment($payment, $chargeAmount);
            }
        }

        if (!$result) {
            throw new Exception('Failed to create a refund!');
        }

        Note::query()
            ->create([
                'order_id' => $orderId,
                'note' => 'A Revolut refund request for £' . $amount . ' has been sent',
            ]);
    }

    }
