<?php

namespace Mtc\RevolutPaymentProvider\Controllers;

use Illuminate\Http\Request;
use Mtc\RevolutPaymentProvider\Services\RevolutOrderService;
use Mtc\RevolutPaymentProvider\Classes\RevolutPayment;
use Mtc\Modules\Members\Classes\Auth;


class RevolutOrderController
{


    public function __construct(
        protected RevolutOrderService $revolutService
    )
    {}

    public function createOrder(Request $request)
    {
        $data = $request->all();
        $dataResponse = $this->revolutService->createOrder($data);

        RevolutPayment::updateOrCreate(
            ['order_id' => $dataResponse['statement_descriptor_suffix'] ?? null],
            [
                'user_id' => Auth::getLoggedInMember()->id,
                'member_id' => $dataResponse['customer']['id'] ?? null,
                'member_email' => $dataResponse['customer']['email'] ?? null,
                'transaction_id' => $dataResponse['id'] ?? null,
                'status' => $dataResponse['state'] ?? 'pending',
                'amount' => ($dataResponse['amount'] ?? 0) / 100,
                'currency' => $dataResponse['currency'] ?? 'GBP',
                'token' => $dataResponse['token'] ?? null,
                'checkout_url' => $dataResponse['checkout_url'] ?? null,
                'raw_response' => $dataResponse,
            ]
        );

        $_SESSION['revolut_order_id'] = $dataResponse['statement_descriptor_suffix'];

        return response()->json($dataResponse);
    }






//    public static function handleRefund($orderId, $amount): void
//    {
//        Log::debug('handleRefund');
//        /** @var RyftPayment $payment */
//        $payment = RyftPayment::query()
//            ->where('order_id', $orderId)
//            ->whereIn('status', [
//                RyftPayment::STATUS_RESERVED,
//                RyftPayment::STATUS_PAID,
//            ])
//            ->firstOrFail();
//
//        Log::debug(print_r($payment, true));
//        if (!empty($amount)) {
//            $amount = number_format($amount, 2);
//            $fullRefund = $amount == $payment->amount;
//        } else {
//            $amount = $payment->amount;
//            $fullRefund = true;
//        }
//
//        if ($payment->status === RyftPayment::STATUS_PAID) {
//            $result = (new self())->refundPayment($payment, $fullRefund ? null : $amount);
//        } else {
//            if ($fullRefund) {
//                $result = (new self())->cancelPayment($payment);
//            } else {
//                $chargeAmount = $payment->amount - $amount;
//                $result = (new self())->capturePayment($payment, $chargeAmount);
//            }
//        }
//
//        if (!$result) {
//            throw new Exception('Failed to create a refund!');
//        }
//
//        Note::query()
//            ->create([
//                'order_id' => $orderId,
//                'note' => 'A RyftPay refund request for £' . $amount . ' has been sent',
//            ]);
//    }


}
