<?php

    namespace Mtc\RevolutPaymentProvider\Controllers\Revolut;

    use Illuminate\Http\Request;
    use Mtc\RevolutPaymentProvider\Classes\RevolutPayment;
    use Order;
    use Twig\TwigFunction;


    class Status
    {
        public function success(Request $request)
        {
            $twig = app('twig');

            $path = '../../../../';

            //require_once $path . 'core/includes/header.inc.php';

            require_once __DIR__ . '/../../../../../core/includes/header.inc.php';


            if (empty($_SESSION['revolut_order_id'])) {
                header('Location: ' . SITE_URL . '/shop');
                die;
            }

            $order = new Order($_SESSION['revolut_order_id']);

            /** @var RevolutPayment $payment */
            $payment = RevolutPayment::query()
                ->where('order_id', $_SESSION['revolut_order_id'])
                ->first();

            if (empty($payment)) {
                header('Location: ' . SITE_URL . '/shop');
                die;
            }

            if ($payment->status === RevolutPayment::STATUS_FAILED) {
                // Payment indeed failed
                $page_meta = [
                    'title' => 'Your order has not been processed | ' . config('app.name'),
                    'page_title' => 'Order issue',
                ];

                echo $twig->render('shop/checkout/order_failed.twig', [
                    'page_html' => '',
                    'page_meta' => $page_meta,
                    'subtitle' => 'Your order failed to process.',
                ]);
                die;
            }

            $this->completeOrder($payment);

            $page_meta = [
                'title' => 'Your order is now complete | ' . config('app.name'),
                'page_title' => 'Order Complete',
                'page_sub_title' => 'Thank you for shopping online with ' . config('app.name'),
            ];

            $tracking_code[] = $twig->render('analytics_js.twig', [
                'order' => $order,
                /*'settings' => $settings,*/
            ]);

            echo $twig->render('shop/checkout/order_complete.twig', [
                'page_html' => '',
                'page_meta' => $page_meta,
                'basket_object' => $order,
                'tracking_code' => $tracking_code,
                'payment_method' => $_GET['method'] ?? '',
            ]);

            unset($_SESSION['revolut_order_id']);
            unset($_SESSION['basket_id']);
            die;

        }

        /**
         * Completes order, marks paid, sends confirmation email
         *
         * @throws Exception
         */
        protected static function completeOrder(RevolutPayment $payment): void
        {
            $order = new Order($payment->order_id);
            if ($order->paid) {
                return;
            }

            $order->markPaid(self::class);
            $order->sendOrderConfirmation();

            if (defined('PPC_TRACKING') && PPC_TRACKING) {
                track('sale', $order->getTotalCost(), $order->ref, $order->keywords);
            }
        }
    }
