<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    

    public function up(): void
    {
        Schema::create('revolut_payments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_id')->index()->nullable();
            $table->unsignedBigInteger('user_id')->index()->nullable();
            $table->string('member_id')->index()->nullable();
            $table->string('member_email')->index()->nullable();
            $table->string('transaction_id')->index()->nullable();
            $table->string('status', 20)->index();
            $table->string('method', 20)->nullable();
            $table->decimal('amount');
            $table->string('currency', 5);
            $table->string('token')->nullable();
            $table->string('checkout_url')->nullable();
            $table->json('raw_response')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */

    public function down(): void
    {
        Schema::dropIfExists('revolut_payments');
    }
};