<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Revolut API Configuration
    |--------------------------------------------------------------------------
    |
    | Here you can configure your Revolut API settings.
    |
    */

    'revolut_enabled'=>env("REVOLUT_ENABLED",false),

    'api_key' => (function() {
        if(env('REVOLUT_TEST_MODE')){
            return env('REVOLUT_SANDBOX_API_KEY');
        }
        return env('REVOLUT_LIVE_API_KEY');
    })(),

    'api_public_key'=> (function() {
        if(env('REVOLUT_TEST_MODE')){
            return env('REVOLUT_SANDBOX_PUBLIC_KEY');
        }
        return env('REVOLUT_LIVE_PUBLIC_KEY');
    })(),

    'api_url' => (function(){
        if(env('REVOLUT_TEST_MODE')){
            return env('REVOLUT_SANDBOX_API_URL');
        }
        return env('REVOLUT_LIVE_API_URL');
    })(),

    'test_mode' => env('REVOLUT_TEST_MODE', false),

    /*
    |--------------------------------------------------------------------------
    | Webhook Configuration
    |--------------------------------------------------------------------------
    |
    | Configure the webhook endpoint and secret for Revolut payment notifications.
    |
    */

    'webhook' => [
        'secret' => (function(){
            if(env('REVOLUT_TEST_MODE')){
                return env('REVOLUT_SANDBOX_WEBHOOK_SECRET');
            }
            return env('REVOLUT_LIVE_WEBHOOK_SECRET');
        })(),
        'endpoint' => env('REVOLUT_WEBHOOK_ENDPOINT', '/api/revolut/webhook'),
    ],
];
