<?php

    use Illuminate\Support\Facades\Route;
    use Mtc\RevolutPaymentProvider\Controllers\Webhook\Order\RevolutWebhookOrderController;
    use Mtc\RevolutPaymentProvider\Controllers\RevolutOrderController;
    use Mtc\RevolutPaymentProvider\Support\Proxy as RevolutProxy;

    Route::withoutMiddleware()
        ->prefix('revolut')
        ->group(function () {
            Route::prefix("order")->group(function () {
                Route::post('/', [RevolutOrderController::class, 'createOrder']);
//                Route::get('{orderId}',[RevolutOrderController::class, 'getOrder']);
            });
            Route::get("success", [RevolutOrderController::class, 'success']);
            Route::prefix("webhook")->group(function () {
                Route::any('order',[RevolutWebhookOrderController::class, 'manage']);
            });

        });
