<?php
    namespace Mtc\RevolutPaymentProvider\Console\Commands;

    class CreateOrderWebhook extends \Illuminate\Console\Command
    {
        protected $signature = 'revolut:create-webhook';
        protected $description = 'Create a webhook for Revolut with selected event types.';

        public function handle()
        {
            $this->info('Revolut Webhook Creation');
            // Define available event types
            $availableEvents = ['ORDER_AUTHORISED', 'ORDER_COMPLETED'];

            // Show multi-select with ORDER_AUTHORISED selected by default
            $events = $this->choice(
                'Select event(s) to subscribe to (comma-separated for multiple)',
                $availableEvents,
                default: ['ORDER_AUTHORISED'], // default selection
                multiple: true
            );

            if (empty($events)) {
                $this->warn('No events selected. Aborting.');
                return;
            }

            // Display selected events
            $this->info('Selected event(s):');
            foreach ($events as $event) {
                $this->line("- $event");
            }


            // Simulate webhook creation logic
            foreach ($events as $event) {
                // Replace with real API call logic
                $this->line("Creating webhook for event: {$event}...");
                sleep(1); // Simulate delay
            }

            $this->info('Webhook(s) created successfully.');


        }
    }
