<?php
    namespace Mtcmedia\RevolutPaymentProvider\Services;

    use Illuminate\Support\Facades\Cache;
    use Illuminate\Support\Facades\Log;
    use Illuminate\Support\Facades\Http;

    class RevolutOrderService
    {
        protected $client;
        const ENDPOINT= "/revolut-api/api/orders";



        public function createOrder($basket){

            $url =env('APP_URL').self::ENDPOINT;

            $body = [
                'amount' => intval($basket['cost_total'] * 100),
                'currency' => $basket['currency'] ?? 'GBP',
                'capture_mode'=> 'automatic',
                'customer' => [
                    'email' => $basket['info'] ?? '',
                    // 'date_of_birth' => '1990-01-01' // if you have this info
                ],
                'description' => 'Order #' . ($basket['orderId'] ?? ''),
                'shipping' => [
                    'address' => [
                        'street_line_1' => $basket['address']['address1'] ?? '',
                        'city' => $basket['address']['city'] ?? '',
                        'country_code' => $basket['address']['country'] ?? '',
                        'postcode' => $basket['address']['postcode'] ?? '',
                    ]
                ],
                'enforce_challenge' => 'forced',
                'statement_descriptor_suffix' => (string) ($basket['orderId'] ?? ''),
                'redirect_url' => env('APP_URL') . '/revolut/success',
            ];

            return Http::post($url, $body)->throw()->collect();

        }

    }
