<?php

namespace Mtcmedia\RevolutPaymentProvider\Classes;

use Basket;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Log;
use Order;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\View;

class RevolutPay
{
    const PAYMENT_SESSIONS_URI = 'payment-sessions';

    public array $errors = [];
    private Basket $basket;
    private array $paymentSession;
    private $config;

    public function __construct(array $config)
    {
        $this->config = $config;
    }

    /**
     * Outputs a form of revolut payments
     */
    public function form($basket)
    {
        $twig = app('twig');
        // Get the total amount from the basket

        return $twig->render('form.twig', [
            "basket" => [
                "orderId"   =>  $basket->order_id,
                "currency"  =>  $basket->currency["currency"],
                "cost_total"  =>  $basket->cost_total,
                "cost_total_exvat"  =>  $basket->cost_total_exvat,
                "info"  =>  $basket->info["email"],
                "address"  =>  $basket->address["billing"]
            ],
        ]);
    }
}
