<?php

    use Illuminate\Support\Facades\Route;
    use Mtcmedia\RevolutPaymentProvider\Controllers\Webhook\Order\RevolutWebhookOrderController;
    use Mtcmedia\RevolutPaymentProvider\Controllers\RevolutOrderController;
    use Mtcmedia\RevolutPaymentProvider\Support\Proxy as RevolutProxy;

    Route::withoutMiddleware()
        ->prefix('revolut')
        ->group(function () {
            Route::prefix("order")->group(function () {
                Route::post('/', [RevolutOrderController::class, 'createOrder']);
//                Route::get('{orderId}',[RevolutOrderController::class, 'getOrder']);
            });
            Route::get("success", [RevolutOrderController::class, 'success']);
            Route::prefix("webhook")->group(function () {
                Route::any('order',[RevolutWebhookOrderController::class, 'manage']);
            });

        });
