const path = require('path');

module.exports = {
    entry: {
        'revolut-pay': './resources/js/revolut-pay.js',
        'revolut-sdk-loader': './resources/js/revolut-sdk-loader.js'
    },
    output: {
        path: path.resolve(__dirname, 'public/js'),
        filename: '[name].js'
    },
    module: {
        rules: [
            {
                test: /\.js$/,
                exclude: /node_modules/,
                use: {
                    loader: 'babel-loader',
                    options: {
                        presets: ['@babel/preset-env']
                    }
                }
            }
        ]
    }
};
