<?php
    namespace Mtcmedia\RevolutPaymentProvider\Services;

    use Mtcmedia\RevolutPaymentProvider\Support\RevolutClient;

    class RevolutService
    {
        protected $client;

        public function __construct(string $apiKey='asdasd', string $environment='sandbox')
        {
            $this->client = new RevolutClient($apiKey, $environment);
        }

        public function createPayment(array $data)
        {
            return $this->client->post('/payments', $data);
        }

        public function getPayment(string $paymentId)
        {
            return $this->client->get("/payments/{$paymentId}");
        }

        public function capturePayment(string $paymentId)
        {
            return $this->client->post("/payments/{$paymentId}/capture");
        }

        public function refundPayment(string $paymentId, array $data)
        {
            return $this->client->post("/payments/{$paymentId}/refund", $data);
        }
    }
