<?php

namespace Mtcmedia\RevolutPaymentProvider\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Mtcmedia\RevolutPaymentProvider\Services\RevolutPaymentService;

class RevolutPaymentController
{
    protected $paymentService;

    public function __construct(RevolutPaymentService $paymentService)
    {
        $this->paymentService = $paymentService;
    }

    public function createOrder(Request $request): JsonResponse
    {
        try {
            $validated = $request->validate([
                'amount' => 'required|numeric|min:0',
                'currency' => 'required|string|size:3'
            ]);

            $order = $this->paymentService->createOrder(
                $validated['amount'],
                $validated['currency']
            );

            return response()->json($order);
        } catch (\Exception $e) {
            return response()->json([
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function handleWebhook(Request $request): JsonResponse
    {
        try {
            $this->paymentService->handleWebhook($request->all());
            return response()->json(['status' => 'success']);
        } catch (\Exception $e) {
            return response()->json([
                'error' => $e->getMessage()
            ], 500);
        }
    }
}
