// Debug function to log information
function debugRevolutPay(message, data = null) {
    const debugInfo = document.getElementById('revolut-debug-info');
    const timestamp = new Date().toISOString();
    let logMessage = `[${timestamp}] ${message}`;
    if (data) {
        logMessage += '\n' + JSON.stringify(data, null, 2);
    }
    if (debugInfo) {
        debugInfo.textContent += logMessage + '\n\n';
    }
    console.log(message, data);
}

// Log initial configuration
document.addEventListener('DOMContentLoaded', function() {
    const container = document.querySelector('.revolut-pay');
    if (container) {
        const config = container.dataset.revolutConfig;
        debugRevolutPay('Initial Revolut configuration:', JSON.parse(config));
    } else {
        debugRevolutPay('Revolut container not found');
    }
}); 