<?php

    namespace Mtcmedia\RevolutPaymentProvider;

    use Illuminate\Support\ServiceProvider;
    use Illuminate\Support\Facades\Gate;
    use Illuminate\Support\Facades\App;
    use Illuminate\Support\Facades\Event;
    use Mtcmedia\RevolutPaymentProvider\Classes\RevolutPay;


    class RevolutServiceProvider extends ServiceProvider
    {



        /**
         * Register services.
         */
        public function register()
        {
            $this->mergeConfigFrom(
                __DIR__.'/../config/revolut.php', 'revolut'
            );

            Event::listen('shop.checkout.load_payment_gateways', '\\' . RevolutPay::class . '@form');

            $this->app->singleton(RevolutService::class, function ($app) {
                return new RevolutService(
                    config('revolut.api_key'),
                    config('revolut.environment')
                );
            });
        }

        /**
         * Bootstrap services.
         */
        public function boot()
        {
            // Load routes
            $this->loadRoutesFrom(__DIR__.'/../routes/web.php');


            // Register package views for Twig
            $this->registerTwigTemplatePath();


//            // Load views
//            $this->loadViewsFrom(__DIR__.'/../resources/views', 'revolut');

            // Load translations
            $this->loadTranslationsFrom(__DIR__.'/../resources/lang', 'revolut');

            // Publish config file
            if ($this->app->runningInConsole()) {
                $this->publishes([
                    __DIR__.'/../config/revolut.php' => config_path('revolut.php'),
                ], 'revolut-config');


                // Publish assets
                $this->publishes([
                    __DIR__.'/../resources/js' => public_path('vendor/revolut/js'),
                    __DIR__.'/../resources/css' => public_path('vendor/revolut/css'),
                ], 'revolut-assets');
            }
        }


        protected function registerTwigTemplatePath(): void
        {
            // Pharmacy platform uses custom twig template loaders.
            $view_paths = \Config::get('view.paths');
            $view_paths[] = dirname(__DIR__, 1) . '/resources/templates';
            \Config::set('view.paths', $view_paths);
        }
    }
