<?php

namespace Mtc\Returns\Rules;

use Carbon\Carbon;
use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\App;
use Mtc\Orders\Contracts\OrderContract;

/**
 * Class ReturnRequestIsNotPastExpiry
 *
 * @package Mtc\Orders
 */
class ReturnRequestIsNotPastExpiry implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (config('returns.expiry_days') == 0) {
            return true;
        }

        return App::make(OrderContract::class)
            ->newQuery()
            ->where('reference', $value)
            ->where('paid_at', '>=', Carbon::now()->subDays(config('returns.expiry_days')))
            ->exists();
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Unfortunately this order cannot be returned as it is past term outlined in our return policy.';
    }
}
