<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddRefundedAmountColumnToReturnItems extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasColumn('return_items', 'refunded_amount') === false) {
            Schema::table('return_items', function (Blueprint $table) {
                $table->double('refunded_amount')
                    ->unsigned()
                    ->default(0)
                    ->after('approved_quantity');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('return_items', 'refunded_amount') !== false) {
            Schema::table('return_items', function (Blueprint $table) {
                $table->dropColumn('refunded_amount');
            });
        }
    }
}
