<?php

namespace Mtc\Returns\Listeners;

use Mtc\Returns\Events\ReturnCancelled;

/**
 * Class ReturnCancelledEmail
 *
 * @package Mtc\Returns\Listeners
 */
class ReturnCancelledEmail
{
    /**
     * Handle the event.
     *
     * @param  ReturnCancelled $event
     * @return void
     */
    public function handle(ReturnCancelled $event)
    {
        $subject = __('returns::returns.return_cancelled_email_subject');
        $content = template('emails/returns/return_cancelled.twig', [
            'return' => $event->return,
        ]);

        email($event->return->order->email, $subject, $content);
    }
}
