<?php

namespace Mtc\Returns\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Mtc\Returns\Rules\ApplicableOrderItemReturnQuantity;

/**
 * Class ValidReturnUpdateRequest
 * @package Mtc\Returns\Http\Requests
 */
class ValidReturnUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'reason_id.*' => 'required|exists:return_reasons,id',
            'approved_quantity.*' => [
                'numeric',
                'min:0',
                new ApplicableOrderItemReturnQuantity($this->request->get('return_id'))
            ],
        ];
    }
}
