<?php

namespace Mtc\Returns;

use Illuminate\Database\Eloquent\Model;
use Mtc\Orders\Item;

/**
 * Class ReturnItem
 *
 * @package Mtc\Returns
 */
class ReturnItem extends Model
{
    protected $fillable = [
        'purchasable_id',
        'purchasable_type',
        'return_id',
        'order_item_id',
        'reason_id',
        'requested_quantity',
        'approved_quantity',
    ];

    /**
     * Morph to purchasable that is getting returned
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function purchasable()
    {
        return $this->morphTo();
    }

    /**
     * Return Request
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function returnRequest()
    {
        return $this->belongsTo(ReturnRequest::class, 'return_id');
    }

    /**
     * Item getting exchanged for this return item
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function exchangeItem()
    {
        return $this->hasOne(ExchangeItem::class, 'return_item_id');
    }

    /**
     * Order Item that is getting returned
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function orderItem()
    {
        return $this->belongsTo(Item::class, 'order_item_id');
    }

    /**
     * Reason for being returned
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function reason()
    {
        return $this->belongsTo(ReturnReason::class);
    }

}
