<?php

namespace Mtc\Returns;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Event;
use Mtc\Core\Admin\User;
use Mtc\Orders\Contracts\OrderContract;
use Mtc\Returns\Events\NewReturn;
use Mtc\Returns\Events\ReturnCancelled;
use Mtc\Returns\Events\ReturnProcessed;
use Mtc\Returns\Http\Presenters\ReturnRequestUrlPresenter;
use Mtc\Returns\Scopes\ExcludesDraft;

/**
 * Class ReturnHistory
 *
 * @package Mtc\Returns
 */
class ReturnHistory extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'return_history';

    /**
     * Mass assignable attributes
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'text',
    ];

    /**
     * Items in this return request
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function returnRequest()
    {
        return $this->belongsTo(ReturnRequest::class, 'return_id');
    }

    /**
     * Order for which a return has been submitted
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * @return string
     */
    public function getTriggeredByAttribute()
    {
        return $this->user->name ?? 'Customer';
    }
}
