<?php

namespace Mtc\Returns\Http\Controllers;

use App\Http\Controllers\Controller;
use Mtc\Modules\Members\Classes\Auth;
use Mtc\Returns\ReturnRequest;

/**
 * Class MemberReturnController
 *
 * @package Mtc\Returns
 */
class MemberReturnController extends Controller
{
    /**
     * Render the page
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $member = Auth::getLoggedInMember();
        if (!$member->exists) {
            return redirect()->to('/members/login?redirect=/members/returns');
        }

        $this->page_meta['page_title'] = __('returns::returns.list_requests');
        $requests = ReturnRequest::query()
            ->whereHas('order', function ($order_query) use ($member) {
                return $order_query->where('member_id', $member->id);
            })
            ->latest()
            ->get();

        return template('returns/member/index.twig', [
            'page_meta' => $this->page_meta,
            'return_requests' => $requests
        ]);
    }

    /**
     * Render the page
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show(ReturnRequest $request)
    {
        $member = Auth::getLoggedInMember();
        if (!$member->exists) {
            return redirect()->to('/members/login?redirect=/members/returns/' . $request->id);
        }

        if ($member->id != $request->order->member_id) {
            session()->flash('error', "You don't have access to requested URL");
            return redirect()->to('/members/returns/');
        }

        $request->load('items.orderItem');
        $this->page_meta['page_title'] = __('returns::returns.view_request');

        return template('returns/member/view.twig', [
            'page_meta' => $this->page_meta,
            'request' => $request
        ]);
    }

}
