<?php

namespace Mtc\Returns\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Mtc\Orders\Rules\ValidOrderReference;
use Mtc\Returns\Rules\EmailMatchesOrderReference;

/**
 * Class CreateReturnRequest
 *
 * @package Mtc\Returns
 */
class CreateReturnRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'reference' => [
                'required',
                new ValidOrderReference(),
            ],
            'order.id' => 'required|exists:orders,id',
            'message' => 'sometimes',
            'order.returnable_items.*.order_item_id' => 'required|exists:order_items,id',
            'order.returnable_items.*.requested_quantity' => 'required|numeric',
            'order.returnable_items.*.request_type' => 'required_unless:order.returnable_items.*.requested_quantity,0',
            'order.returnable_items.*.reason' => 'required_unless:order.returnable_items.*.requested_quantity,0',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'order.returnable_items.*.request_type' => 'request type',
            'order.returnable_items.*.reason' => 'reason',
            'order.returnable_items.*.requested_quantity' => 'quantity',
            'order.returnable_items.*.order_item_id' => 'item',
        ];
    }
}
