<?php

namespace Mtc\Returns;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ReturnReason
 *
 * @package Mtc\Returns
 */
class ReturnReason extends Model
{
    /**
     * Mass assignable attributes
     *
     * @var array
     */
    protected $fillable = [
        'type',
        'code',
        'name',
        'reallocate_stock',
        'admin_only',
    ];

    /**
     * Cast attributes to certain types
     *
     * @var array
     */
    protected $casts = [
        'reallocate_stock' => 'boolean',
        'admin_only' => 'boolean',
    ];

    /**
     * JSON response visible attributes
     *
     * @var array
     */
    protected $visible = [
        'id',
        'name',
        'type',
    ];

    /**
     * Filter public access reasons
     *
     * @param Builder $query
     * @return Builder
     */
    public function scopePublic(Builder $query)
    {
        return $query->where('admin_only', 0);
    }

    /**
     * List all reasons optimised for
     *
     * @return \Illuminate\Database\Eloquent\Collection|\Illuminate\Support\Collection|ReturnReason[]
     */
    public static function listAll()
    {
        return self::all()
            ->keyBy('id')
            ->map(function ($reason) {
                return ucwords($reason->type  . ' - ' . $reason->name);
            });
    }
}
