<?php

namespace Mtc\Returns\Http\Controllers;

use App\Http\Controllers\Controller;
use Mtc\Modules\Members\Classes\Auth;
use Mtc\Returns\Http\Requests\CreateReturnRequest;
use Mtc\Returns\Http\Requests\ReturnSearchRequest;
use Mtc\Orders\Contracts\OrderContract;
use Mtc\Returns\Http\Resources\ReturnRequestResponse;
use Mtc\Returns\ReturnRequest;
use Mtc\Shop\Order\Item;

/**
 * Class ReturnController
 *
 * @package Mtc\Returns
 */
class ReturnController extends Controller
{
    /**
     * Render the page
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(OrderContract $order, $order_id = null)
    {
        $this->page_meta['page_title'] = __('returns::returns.title');
        return template('returns/index.twig', [
            'page_meta' => $this->page_meta,
            'order' => $order->newQuery()->find($order_id)
        ]);
    }

    /**
     * Find order for which to create a return
     *
     * @param ReturnSearchRequest $request
     * @param OrderContract $order
     * @return ReturnRequestResponse
     */
    public function find(ReturnSearchRequest $request, OrderContract $order)
    {
        $order = $order->where('reference', $request->input('reference'))
            ->where('email', $request->input('email'))
            ->firstOrFail();
        return new ReturnRequestResponse($order);
    }

    /**
     * Create the return request
     *
     * @param CreateReturnRequest $request
     * @param ReturnRequest $return
     * @return array
     */
    public function store(CreateReturnRequest $request, ReturnRequest $return)
    {
        $return->fill($request->input());
        $return->order_id = $request->input('order.id');
        $return->status_id = config('returns.statuses.requested');
        $return->save();

        collect($request->input('order.returnable_items'))
            ->filter(function ($item) {
                return !empty($item['requested_quantity']);
            })
            ->each(function ($item) use ($return) {
                $order_item = Item::query()->find($item['order_item_id']);
                $return->items()
                    ->create([
                        'order_item_id' => $item['order_item_id'],
                        'purchasable_id' => $order_item->purchasable_id,
                        'purchasable_type' => $order_item->purchasable_type,
                        'requested_quantity' => $item['requested_quantity'],
                        'reason_id' => $item['reason'],
                    ]);
            });

        $return->history()
            ->create([
                'user_id' => 0,
                'text' => 'Created return request',
            ]);

        return [
            'status' => 'ok',
        ];
    }
}
