<?php

namespace Mtc\Reports\Tests;

use Illuminate\Database\Eloquent\Model;
use Maatwebsite\Excel\ExcelServiceProvider;
use Mtc\Reports\Providers\ReportProvider;
use Orchestra\Testbench\TestCase as Orchestra;

class TestCase extends Orchestra
{
    protected function getPackageProviders($app)
    {
        return [
            ReportProvider::class,
            ExcelServiceProvider::class,
        ];
    }

    protected function getEnvironmentSetUp($app): void
    {
        include_once __DIR__ . '/setup/migrations/2014_10_12_000000_testbench_create_users_table.php';
        (new \TestbenchCreateUsersTable)->up();

        Model::preventLazyLoading();
    }

}
