<?php

namespace Mtc\Reports\Mail;

use App\Facades\Settings;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Support\Carbon;
use Illuminate\Mail\Attachment;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Queue\SerializesModels;
use Mtc\Reports\Contracts\ReportModel;

class ReportMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(
        protected $data,
        protected ReportModel $report,
        protected ?Attachment $attachment = null
    ) {
        $this->subject = sprintf(
            '[Report] %s - %s - %s',
            $this->report->name,
            Settings::get('app-name'),
            Carbon::now()->format('jS F y')
        );

        if ($this->attachment) {
            $this->attach($this->attachment);
        }
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function content()
    {
        return new Content(
            markdown: $this->report->sendAsFile() ? 'reports::with_attachment' : 'reports::inline',
            with: [
                'data' => $this->data,
                'report' => $this->report,
            ]
        );
    }
}
