<?php

namespace Mtc\Reports\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Carbon;
use Mtc\Reports\Contracts\ReportModel;

class ReportMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(protected $data, protected ReportModel $report, protected $attachment = null)
    {
        //
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view(
            $this->report->sendAsFile() ? 'reports::with_attachment' : 'reports::inline',
            [
                'data' => $this->data,
                'report' => $this->report,
            ])
            ->when($this->attachment, fn (Mailable $mailable) => $mailable->attach($this->attachment))
            ->subject('[Report] ' . $this->report->name . ' - ' . Carbon::now()->format('jS F y'));
    }
}
