<?php

namespace Mtc\Reports\ReportTypes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;

class UserReport
{
    /**
     * Report name
     *
     * @return string
     */
    public function name(): string
    {
        return 'Users';
    }

    /**
     * Columns that can be used
     *
     * @return string[]
     */
    public function columns(): array
    {
        return [
            'email',
            'name',
        ];
    }

    /**
     * Start a query
     *
     * @return Builder
     */
    public function query(): Builder
    {
        return App::make(Config::get('auth.providers.users.model'))->newQuery();
    }
}
