<?php

namespace Mtc\Reports\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Reports\Contracts\ReportModel;
use Mtc\Reports\Facades\Reports;

class RunReporting extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reports:run';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run reporting task to send out reports';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        Reports::getDueReports()->each(fn (ReportModel $report) => Reports::run($report));
        return 0;
    }
}
