<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Automated loading
    |--------------------------------------------------------------------------
    |
    | Flags to define whether migrations, routes and task scheduling is done
    | automatically. Disabling them from the package space allows for setting
    | them up in a custom pattern (e.g. multi-tenancy migrations).
    |
    */

    'auto_load_migrations' => true,
    'load_routes' => true,
    'schedule_tasks' => true,

    /*
    |--------------------------------------------------------------------------
    | Data types
    |--------------------------------------------------------------------------
    |
    | Type setting allows specifying what type of report this will be. The
    | intended use is to specify which data model will be used (e.g. Products,
    | Users, Enquiries).
    |
    */
    'types' => [
        'users' => \Mtc\Reports\ReportTypes\UserReport::class
    ],

    /*
    |--------------------------------------------------------------------------
    | Export formats
    |--------------------------------------------------------------------------
    |
    | This option allows to specify how to format the exported information.
    | System allows for content to be an in-email table as well as csv and
    | xlsx file exports by default. Format is specified on each report.
    | Formats as attachments allows to specify how to handle export process
    | to desired format
    |
    */

    'export_formats' => [
        'in_email_table',
        'csv',
        'xlsx',
    ],

    'formats_as_attachments' => [
        'csv' => \Mtc\Reports\Exports\ReportExport::class,
        'xlsx' => \Mtc\Reports\Exports\ReportExport::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Schedule types
    |--------------------------------------------------------------------------
    |
    | These options are used to specify how the scheduling of reports work.
    | The types will specify when the next report is due based on the
    | given report send-out time.
    |
    */

    'schedule_types' => [
        'daily' => \Mtc\Reports\Schedule\Daily::class,
        'weekly' => \Mtc\Reports\Schedule\Weekly::class,
        'biweekly' => \Mtc\Reports\Schedule\BiWeekly::class,
        'monthly' => \Mtc\Reports\Schedule\Monthly::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Bindings
    |--------------------------------------------------------------------------
    |
    | These options allow defining the data models for extending with custom
    | functionality that is specific for the required use cases
    |
    */

    'report_model' => \Mtc\Reports\Models\Report::class,
    'log_model' => \Mtc\Reports\Models\ReportLog::class,
    'repository' => \Mtc\Reports\ReportRepository::class,
    'report_list_resource' => Mtc\Reports\Http\Resources\ReportListResource::class,

    /*
    |--------------------------------------------------------------------------
    | Log history length
    |--------------------------------------------------------------------------
    |
    | This option allows to specify how many log entries to keep from each
    | report. This acts as a self-cleanup when report is sent out. If null
    | is specified for value then no cleanup will be performed
    |
    */

    'log_length' => 5,

    /*
    |--------------------------------------------------------------------------
    | Query conditions and operators
    |--------------------------------------------------------------------------
    |
    | Query conditions are actions that specify the action of the condition:
    | e.g. and/or use where() / orWhere() methods for creating query
    | Operators are comparison tools that are used when column is compared
    | against an expected value
    |
    */
    'conditions' => [
        'and',
        'or',
        'has',
        'does-not-have',
        'null',
        'or-null',
        'not-null',
        'or-not-null',
        'where-sub',
        'or-where-sub',
    ],
    'operators' => [
        '=',
        '!=',
        'like',
        'like%',
        '%like%',
        '>',
        '>=',
        '<',
        '<=',
        'in',
    ],

    'route_middleware' => [],
];
