<?php

namespace Mtc\Reports\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Attachment;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Carbon;
use Mtc\Reports\Contracts\ReportModel;

class ReportMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(
        protected $data,
        protected ReportModel $report,
        protected ?Attachment $attachment = null
    ) {
        $this->subject = '[Report] ' . $this->report->name . ' - ' . Carbon::now()->format('jS F y');
        if ($this->attachment) {
            $this->attach($this->attachment);
        }
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function content()
    {
        return new Content(
            markdown: $this->report->sendAsFile() ? 'reports::with_attachment' : 'reports::inline',
            with: [
                'data' => $this->data,
                'report' => $this->report,
            ]
        );
    }
}
