<?php

namespace Mtc\Reports\Http\Controllers;

use Illuminate\Http\Request;
use Mtc\Reports\Contracts\ReportModel;
use Mtc\Reports\Http\Requests\StoreReportRequest;
use Mtc\Reports\Http\Requests\UpdateReportRequest;
use Mtc\Reports\Http\Resources\ReportListResource;
use Mtc\Reports\ReportRepository;

class ReportController
{
    /**
     * List of existing reports
     *
     * @param Request $request
     * @param ReportRepository $repository
     * @return ReportListResource
     */
    public function index(Request $request, ReportRepository $repository): ReportListResource
    {
        $resource = config('reports.report_list_resource');
        return new $resource($repository->getList($request));
    }

    /**
     * Show full details of a report
     *
     * @param ReportModel $report
     * @param ReportRepository $repository
     * @return ReportModel
     */
    public function show(ReportModel $report, ReportRepository $repository)
    {
        return $repository->show($report);
    }

    /**
     * Create Report
     *
     * @param StoreReportRequest $request
     * @param ReportRepository $repository
     * @return ReportModel
     */
    public function store(StoreReportRequest $request, ReportRepository $repository)
    {
        return $repository->create($request->input('name'), $request->input('type'));
    }

    /**
     * Update a report
     *
     * @param UpdateReportRequest $request
     * @param ReportModel $report
     * @param ReportRepository $repository
     * @return \Illuminate\Database\Eloquent\Model|ReportModel
     */
    public function update(UpdateReportRequest $request, ReportModel $report, ReportRepository $repository)
    {
        return $repository->update($request, $report);
    }

    /**
     * Delete a report
     *
     * @param int $report
     * @param ReportRepository $repository
     * @return array
     */
    public function destroy(int $report, ReportRepository $repository)
    {
        return [
            'success' => $repository->destroy($report),
        ];
    }
}
