<?php

namespace Mtc\Reports\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Config;
use Mtc\Reports\Factories\ReportLogFactory;

abstract class ReportLogModel extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'report_logs';

    /**
     * @var string[]
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Define model factory
     *
     * @return ReportLogFactory
     */
    protected static function newFactory()
    {
        return ReportLogFactory::new();
    }

    /**
     * Relationship with the report model
     *
     * @return BelongsTo
     */
    public function report(): BelongsTo
    {
        return $this->belongsTo(Config::get('reports.report_model'));
    }
}
