<?php

namespace Mtc\Refunds\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Mtc\Refunds\Refund;

/**
 * Class RefundCreated
 *
 * @package Mtc\Refunds
 */
class RefundCreated
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * @var Refund
     */
    public $refund;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct($refund)
    {
        $this->refund = $refund;
    }
}
