<?php

namespace Mtc\Refunds;

use Illuminate\Database\Eloquent\Model;
use Mtc\Checkout\Invoice;
use Mtc\Refunds\Events\RefundCreated;
use Mtc\Returns\ReturnRequest;

/**
 * Class Refund
 *
 * @package Mtc\Refunds
 */
class Refund extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'invoice_refunds';

    /**
     * Mass assignable attributes
     *
     * @var array
     */
    protected $fillable = [
        'invoice_id',
        'payment_id',
        'return_request_id',
        'amount',
        'reference',
        'details',
    ];

    /**
     * Cast attributes to types
     *
     * @var array
     */
    protected $casts = [
        'details' => 'array'
    ];

    /**
     * Automatically dispatch events on model changes
     *
     * @var array
     */
    protected $dispatchesEvents = [
        'created' => RefundCreated::class,
    ];

    /**
     * Relationship with invoice
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    /**
     * Relationship with payment
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function payment()
    {
        return $this->belongsTo(Invoice\Payment::class);
    }

    /**
     * Relationship with return request creating payment
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function returnRequest()
    {
        return $this->belongsTo(ReturnRequest::class);
    }
}
