<?php

use Illuminate\Routing\Router;
use Mtc\Refunds\Http\Controllers\RefundController;
/** @var Router $router */

$router->group([
    'prefix' => '/admin',
    'middleware' => 'auth'
], function (Router $router) {
    $router->post('/refunds/payment/{payment}', [RefundController::class, 'payment'])->name('refunds.handle-payment');
    $router->get('/refunds/return-request/{return_request}', [RefundController::class, 'viewReturnRequest'])->name('refunds.process-request');
    $router->post('/refunds/return-request/{return_request}', [RefundController::class, 'returnRequest'])->name('refunds.handle-request');
});
