<?php

namespace Mtc\Refunds\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Mtc\Refunds\RefundManager;

/**
 * Class ReturnServiceProvider
 *
 * @package Mtc\Returns
 */
class RefundServiceProvider extends EventServiceProvider
{
    /**
     * Register the service
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/refunds.php', 'refunds');

        collect(config('refunds.service_providers', []))
            ->each(function ($service_provider) {
                $this->app->register($service_provider);
            });


        $this->app->bind('refunds', RefundManager::class);

    }

    /**
     * Boot the service
     */
    public function boot()
    {
        if (config('returns.enabled') !== true) {
            return;
        }

        parent::boot();

        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'refunds');
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');

        if ($this->app->runningInConsole()) {
            $this->publishables();
        }
    }

    /**
     * Service publishables
     */
    public function publishables()
    {
        $this->publishes([
            dirname(__DIR__, 2) . '/config/returns.php' => config_path('returns.php'),
        ], 'config');

        $this->publishes([
            dirname(__DIR__, 2) . '/resources/less' => resource_path('less/vendor'),
        ], 'assets');

        $this->publishes([
            dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
        ], 'assets');

        $this->publishes([
            dirname(__DIR__, 2) . '/resources/lang' => resource_path('lang/vendor/returns'),
        ], 'lang');

    }

    /**
     * Set up the event listeners used by the service provider
     *
     * @return array|\Illuminate\Config\Repository|mixed
     */
    public function listens()
    {
        return config('refunds.events');
    }
}
