# Realex Payments

This package provides payment processing through Realex (Global payments).
This package is intended to be used with mtcmedia/checkout

Realex Documentation: https://developer.globalpay.com/

## Installation
Make sure you are installing this on a project that has `composer.mtcassets.com` added as a resource 
```bash
composer require mtcmedia/realex-payments
```
After composer has installed run the following command that will publish
`realex.js` and `realex_payment.vue` to `/resources/js/vendor/app/` as well as `rxp-hpp.js` to `public/js` 
```bash
php artisan install:realex
```
Lastly recompile assets to ensure stripe payment component is registered
```bash
npm run dev
```

## Setup

We do not have a default account for Realex so keys will need to be obtained 
from client at the start of integration. These can be set in either `.env` file. 
```
REALEX_MERCHANT_ID=
REALEX_ACCOUNT_ID=
REALEX_SHARED_SECRET=
``` 
 
On production server you need to add following keys to `.env` file.  
```
REALEX_USE_LIVE_ENDPOINT=true
```

If client needs to support taking payment in given currency you can specify 
currencies in config. By default `EUR` is supported with `.env` key for account.
Others can be added by defining them in in config.
```
REALEX_EUR_ACCOUNT_ID=
```
 ## Changelog
 See [Changelog](CHANGELOG.md)

## Contributing
Please see [Contributing](CONTRIBUTING.md) for details.

## Quick overview of the integration
This is HPP (Hosted Payment Page) integration. As the name suggests, the form along with all
3DS verification is hosted at Global Payments.

**Payment process:**

(GP = Global Payments)

On the checkout page, `realex_payment.vue` renders a form with a bunch of hidden fields (set up in 
`Realex::getPaymentForm()`)
and immediately submits it to a GP URL using an iframe. The iframe then displays the card form. 
The card details are submitted to HPP, GP processes the payment and returns a response to the 
iframe that then issues a JS window message event to the parent window (our checkout page/ vue component).
The component then submits the results to the payment URL (`/payment/XXX/charge?gateway=realex`)  
which triggers the `Realex` object to decode the HPP response and return the **result** of the transaction.

## Notes

Meaning of the _response_ HPP fields (not easy to find in the docs):

**HPP_POST_RESPONSE**

_Once the transaction is complete, this field tells HPP to post the response back to the parent frame or window, instead of to a nominated URL in your application. Your event listener will receive the following JSON name/value pair string, with the values Base64 encoded._ 

The way this actually works is, although being set to the website *charge* URL, the *post* actually happens using
JS window message event, not an HTTP request, as having a URL might suggest. 

**MERCHANT_RESPONSE_URL**

Used to set which URL in your application the transaction response will be sent to. A fixed URL can also be added to your account by our support team It must be a publicly accessible endpoint so our HPP can connect to it.
