<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Payment Gateway keys
    |--------------------------------------------------------------------------
    |
    | Please set site specific keys in .env file
    | These keys are bound to mtc test account.
    | Production keys should never be part of tracked repo
    |
    */
    'merchant_id' => env('REALEX_MERCHANT_ID', ''),
    'account_id' => env('REALEX_ACCOUNT_ID', ''),
    'secret' => env('REALEX_SHARED_SECRET', ''),

    /*
    |--------------------------------------------------------------------------
    | Gateway mode
    |--------------------------------------------------------------------------
    |
    | Whether to use staging or live endpoint
    |
    */
    'use_production_endpoint' => env('REALEX_USE_LIVE_ENDPOINT', false),

    /*
    |--------------------------------------------------------------------------
    | Card Storage
    |--------------------------------------------------------------------------
    |
    | Enables Global Payments Card Storage.
    | Adds checkbox to payment form offering saving card details for later
    | If user is logged in and has saved cards those can be used without
    | inputting card details.
    |
    | NB! Realex charges for this separately so it will need to be enabled
    | on clients account
    |
    */
    'use_card_storage' => false,

    /*
    |--------------------------------------------------------------------------
    | Payment gateway verifier
    |--------------------------------------------------------------------------
    |
    | Class that allows you to set whether this order can be paid with this payment gateway
    |
    */
    'applicable_check_class' => \Mtc\Realex\RealexApplicableCheck::class,

    /*
    |--------------------------------------------------------------------------
    | Confirmation status
    |--------------------------------------------------------------------------
    |
    | Status that will be set on order when it is paid using this payment gateway.
    | Allows switching to "Awaiting Payment" or other statuses based on necessity.
    |
    */

    'confirmation_status' => 1,

    /*
    |--------------------------------------------------------------------------
    | Enable Multi-currency
    |--------------------------------------------------------------------------
    |
    | Allows placing payments in currently selected currency.
    | Requires setup from Realex side.
    | It is very likely multi-currency setup will provide separate account ID
    |
    */

    'multi_currency_enabled' => false,

    'currency_specific_account_ids' => [
        'EUR' => env('REALEX_EUR_ACCOUNT_ID'),
    ],

];
