# Realex Payments

This package provides payment processing through Realex (Global payments).
This package is intended to be used with mtcmedia/checkout

Realex Documentation: https://developer.globalpay.com/

## Installation
Make sure you are installing this on a project that has `composer.mtcassets.com` added as a resource 
```bash
composer require mtcmedia/realex-payments
```
After composer has installed run the following command that will publish
`realex.js` and `realex_payment.vue` to `/resources/js/vendor/app/` as well as `rxp-hpp.js` to `public/js` 
```bash
php artisan install:realex
```
Lastly recompile assets to ensure stripe payment component is registered
```bash
npm run dev
```

## Setup

We do not have a default account for Realex so keys will need to be obtained 
from client at the start of integration. These can be set in either `.env` file. 
```
REALEX_MERCHANT_ID=
REALEX_ACCOUNT_ID=
REALEX_SHARED_SECRET=
``` 
 
On production server you need to add following keys to `.env` file.  
```
REALEX_USE_LIVE_ENDPOINT=true
```

If client needs to support taking payment in given currency you can specify 
currencies in config. By default `EUR` is supported with `.env` key for account.
Others can be added by defining them in in config.
```
REALEX_EUR_ACCOUNT_ID=
```
 ## Changelog
 See [Changelog](CHANGELOG.md)

## Contributing
Please see [Contributing](CONTRIBUTING.md) for details.
